package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantInteger extends Constant implements SimpleConstant {

    private int intValue;

    public ConstantInteger(int intValue) {
        super(Constants.CONSTANT_Integer);
        this.intValue = intValue;
    }

    ConstantInteger(DataInputStream file) throws IOException {
        this(file.readInt());
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitConstantInteger(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(tag);
        file.writeInt(intValue);
    }

    @Override
    public final String toString() {
        return super.toString() + "(bytes = " + intValue + ")";
    }

    @Override
    public Integer getValue() {
        return intValue;
    }

    public int getIntValue() {
        return intValue;
    }

    public String getStringValue() {
        return Integer.toString(intValue);
    }
}
