package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.IOException;

public final class ConstantInterfaceMethodref extends ConstantCP {

    ConstantInterfaceMethodref(DataInputStream file) throws IOException {
        super(Constants.CONSTANT_InterfaceMethodref, file);
    }

    public ConstantInterfaceMethodref(int classIndex, int nameAndTypeIndex) {
        super(Constants.CONSTANT_InterfaceMethodref, classIndex, nameAndTypeIndex);
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitConstantInterfaceMethodref(this);
    }

    @Override
    public String getValue() {
        return toString();
    }
}
