package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantLong extends Constant implements SimpleConstant {

    private long longValue;

    public ConstantLong(long longValue) {
        super(Constants.CONSTANT_Long);
        this.longValue = longValue;
    }

    ConstantLong(DataInputStream file) throws IOException {
        this(file.readLong());
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitConstantLong(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(tag);
        file.writeLong(longValue);
    }

    @Override
    public final Long getValue() {
        return longValue;
    }

    public final String getStringValue() {
        return Long.toString(longValue);
    }

    @Override
    public final String toString() {
        return super.toString() + "(longValue = " + longValue + ")";
    }
}
