package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantMethodType extends Constant {

    private int descriptorIndex;

    ConstantMethodType(DataInputStream file) throws IOException {
        this(file.readUnsignedShort());
    }

    public ConstantMethodType(int descriptorIndex) {
        super(Constants.CONSTANT_MethodType);
        this.descriptorIndex = descriptorIndex;
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(tag);
        file.writeShort(descriptorIndex);
    }

    public final int getDescriptorIndex() {
        return descriptorIndex;
    }

    @Override
    public final String toString() {
        return super.toString() + "(descriptorIndex=" + descriptorIndex + ")";
    }

    @Override
    public String getValue() {
        return toString();
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitConstantMethodType(this);
    }
}
