package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantNameAndType extends Constant {

    private int name_index;

    private int signature_index;

    ConstantNameAndType(DataInputStream file) throws IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort());
    }

    public ConstantNameAndType(int name_index, int signature_index) {
        super(Constants.CONSTANT_NameAndType);
        this.name_index = name_index;
        this.signature_index = signature_index;
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitConstantNameAndType(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(tag);
        file.writeShort(name_index);
        file.writeShort(signature_index);
    }

    public final int getNameIndex() {
        return name_index;
    }

    public final String getName(ConstantPool cp) {
        return cp.constantToString(getNameIndex(), Constants.CONSTANT_Utf8);
    }

    public final int getSignatureIndex() {
        return signature_index;
    }

    public final String getSignature(ConstantPool cp) {
        return cp.constantToString(getSignatureIndex(), Constants.CONSTANT_Utf8);
    }

    @Override
    public final String toString() {
        return super.toString() + "(name_index = " + name_index + ", signature_index = " + signature_index + ")";
    }

    @Override
    public String getValue() {
        return toString();
    }
}
