package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantPackage extends Constant {

    private int nameIndex;

    ConstantPackage(DataInputStream file) throws IOException {
        this(file.readUnsignedShort());
    }

    public ConstantPackage(int nameIndex) {
        super(Constants.CONSTANT_Package);
        this.nameIndex = nameIndex;
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitConstantPackage(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(tag);
        file.writeShort(nameIndex);
    }

    @Override
    public Integer getValue() {
        return nameIndex;
    }

    public final int getNameIndex() {
        return nameIndex;
    }

    @Override
    public final String toString() {
        return super.toString() + "(name_index = " + nameIndex + ")";
    }

    public String getPackageName(ConstantPool cpool) {
        Constant c = cpool.getConstant(nameIndex, Constants.CONSTANT_Utf8);
        return ((ConstantUtf8) c).getValue();
    }
}
