package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantString extends Constant {

    private int stringIndex;

    ConstantString(DataInputStream file) throws IOException {
        this(file.readUnsignedShort());
    }

    public ConstantString(int stringIndex) {
        super(Constants.CONSTANT_String);
        this.stringIndex = stringIndex;
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitConstantString(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(tag);
        file.writeShort(stringIndex);
    }

    @Override
    public Integer getValue() {
        return stringIndex;
    }

    public final int getStringIndex() {
        return stringIndex;
    }

    @Override
    public final String toString() {
        return super.toString() + "(string_index = " + stringIndex + ")";
    }

    public String getString(ConstantPool cpool) {
        Constant c = cpool.getConstant(stringIndex, Constants.CONSTANT_Utf8);
        return ((ConstantUtf8) c).getValue();
    }
}
