package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantUtf8 extends Constant implements SimpleConstant {

    private String string;

    ConstantUtf8(DataInputStream file) throws IOException {
        super(Constants.CONSTANT_Utf8);
        string = file.readUTF();
    }

    public ConstantUtf8(String string) {
        super(Constants.CONSTANT_Utf8);
        assert string != null;
        this.string = string;
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitConstantUtf8(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(tag);
        file.writeUTF(string);
    }

    @Override
    public final String toString() {
        return super.toString() + "(\"" + Utility.replace(string, "\n", "\\n") + "\")";
    }

    @Override
    public String getValue() {
        return string;
    }

    public String getStringValue() {
        return string;
    }
}
