package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EnclosingMethod extends Attribute {

    private int classIndex;

    private int methodIndex;

    public EnclosingMethod(int nameIndex, int len, DataInputStream dis, ConstantPool cpool) throws IOException {
        this(nameIndex, len, dis.readUnsignedShort(), dis.readUnsignedShort(), cpool);
    }

    private EnclosingMethod(int nameIndex, int len, int classIdx, int methodIdx, ConstantPool cpool) {
        super(Constants.ATTR_ENCLOSING_METHOD, nameIndex, len, cpool);
        classIndex = classIdx;
        methodIndex = methodIdx;
    }

    public void accept(ClassVisitor v) {
        v.visitEnclosingMethod(this);
    }

    public Attribute copy(ConstantPool constant_pool) {
        throw new RuntimeException("Not implemented yet!");
    }

    public final int getEnclosingClassIndex() {
        return classIndex;
    }

    public final int getEnclosingMethodIndex() {
        return methodIndex;
    }

    public final void setEnclosingClassIndex(int idx) {
        classIndex = idx;
    }

    public final void setEnclosingMethodIndex(int idx) {
        methodIndex = idx;
    }

    public final ConstantClass getEnclosingClass() {
        ConstantClass c = (ConstantClass) cpool.getConstant(classIndex, Constants.CONSTANT_Class);
        return c;
    }

    public final ConstantNameAndType getEnclosingMethod() {
        if (methodIndex == 0)
            return null;
        ConstantNameAndType nat = (ConstantNameAndType) cpool.getConstant(methodIndex, Constants.CONSTANT_NameAndType);
        return nat;
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(classIndex);
        file.writeShort(methodIndex);
    }
}
