package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.generic.Type;

import java.io.DataInputStream;
import java.io.IOException;

public final class Field extends FieldOrMethod {

    public static final Field[] NoFields = new Field[0];

    private Type fieldType = null;

    private Field() {
    }

    public Field(Field c) {
        super(c);
    }

    Field(DataInputStream dis, ConstantPool cpool) throws IOException {
        super(dis, cpool);
    }

    public Field(int modifiers, int nameIndex, int signatureIndex, Attribute[] attributes, ConstantPool cpool) {
        super(modifiers, nameIndex, signatureIndex, attributes, cpool);
    }

    public void accept(ClassVisitor v) {
        v.visitField(this);
    }

    public final ConstantValue getConstantValue() {
        return AttributeUtils.getConstantValueAttribute(attributes);
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder(Utility.accessToString(modifiers));
        if (buf.length() > 0) {
            buf.append(" ");
        }
        String signature = Utility.signatureToString(getSignature());
        buf.append(signature).append(" ").append(getName());
        ConstantValue cv = getConstantValue();
        if (cv != null) {
            buf.append(" = ").append(cv);
        }
        for (Attribute a : attributes) {
            if (!(a instanceof ConstantValue)) {
                buf.append(" [").append(a.toString()).append("]");
            }
        }
        return buf.toString();
    }

    public Type getType() {
        if (fieldType == null) {
            fieldType = Type.getReturnType(getSignature());
        }
        return fieldType;
    }
}
