package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class LineNumber implements Node {

    private int startPC;

    private int lineNumber;

    public LineNumber(LineNumber c) {
        this(c.getStartPC(), c.getLineNumber());
    }

    LineNumber(DataInputStream file) throws IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort());
    }

    public LineNumber(int startPC, int lineNumber) {
        this.startPC = startPC;
        this.lineNumber = lineNumber;
    }

    public void accept(ClassVisitor v) {
        v.visitLineNumber(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeShort(startPC);
        file.writeShort(lineNumber);
    }

    public final int getLineNumber() {
        return lineNumber;
    }

    public final int getStartPC() {
        return startPC;
    }

    @Override
    public final String toString() {
        return "LineNumber(" + startPC + ", " + lineNumber + ")";
    }

    public LineNumber copy() {
        return new LineNumber(this);
    }
}
