package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModuleMainClass extends Attribute {

    private int mainClassIndex;

    public ModuleMainClass(ModuleMainClass c) {
        this(c.getNameIndex(), c.getLength(), c.getMainClassIndex(), c.getConstantPool());
    }

    public ModuleMainClass(int nameIndex, int length, int mainClassIndex, ConstantPool cp) {
        super(Constants.ATTR_MODULE_MAIN_CLASS, nameIndex, length, cp);
        this.mainClassIndex = mainClassIndex;
    }

    ModuleMainClass(int nameIndex, int length, DataInputStream stream, ConstantPool cp) throws IOException {
        this(nameIndex, length, 0, cp);
        this.mainClassIndex = stream.readUnsignedShort();
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitModuleMainClass(this);
    }

    @Override
    public final void dump(DataOutputStream stream) throws IOException {
        super.dump(stream);
        stream.writeShort(mainClassIndex);
    }

    public final int getMainClassIndex() {
        return mainClassIndex;
    }

    @Override
    public final String toString() {
        return cpool.getConstantString_CONSTANTClass(mainClassIndex);
    }
}
