package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModulePackages extends Attribute {

    private static int[] NO_PACKAGES = new int[0];

    private int[] packageIndices;

    public ModulePackages(ModulePackages c) {
        this(c.getNameIndex(), c.getLength(), c.getPackageIndices(), c.getConstantPool());
    }

    public ModulePackages(int nameIndex, int length, int[] packageIndices, ConstantPool cp) {
        super(Constants.ATTR_MODULE_PACKAGES, nameIndex, length, cp);
        setPackageIndices(packageIndices);
    }

    ModulePackages(int nameIndex, int length, DataInputStream stream, ConstantPool cp) throws IOException {
        this(nameIndex, length, (int[]) null, cp);
        int packageIndicesCount = stream.readUnsignedShort();
        packageIndices = new int[packageIndicesCount];
        for (int i = 0; i < packageIndicesCount; i++) {
            packageIndices[i] = stream.readUnsignedShort();
        }
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitModulePackages(this);
    }

    @Override
    public final void dump(DataOutputStream stream) throws IOException {
        super.dump(stream);
        stream.writeShort(packageIndices.length);
        for (int packageIndex : packageIndices) {
            stream.writeShort(packageIndex);
        }
    }

    public final int[] getPackageIndices() {
        return packageIndices;
    }

    public final void setPackageIndices(int[] packageIndices) {
        if (packageIndices == null) {
            this.packageIndices = NO_PACKAGES;
        } else {
            this.packageIndices = packageIndices;
        }
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder();
        for (int packageIndex : packageIndices) {
            buf.append(cpool.getPackageName(packageIndex) + "\n");
        }
        return buf.toString();
    }
}
