package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class NestHost extends Attribute {

    private int hostClassIndex;

    public NestHost(NestHost c) {
        this(c.getNameIndex(), c.getLength(), c.getHostClassIndex(), c.getConstantPool());
    }

    public NestHost(int nameIndex, int length, int hostClassIndex, ConstantPool cp) {
        super(Constants.ATTR_NEST_MEMBERS, nameIndex, length, cp);
        this.hostClassIndex = hostClassIndex;
    }

    NestHost(int nameIndex, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(nameIndex, length, 0, constant_pool);
        hostClassIndex = file.readUnsignedShort();
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitNestHost(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(hostClassIndex);
    }

    public final int getHostClassIndex() {
        return hostClassIndex;
    }

    public final void setHostClassIndex(int hostClassIndex) {
        this.hostClassIndex = hostClassIndex;
    }

    public final String getHostClassName() {
        ConstantClass constantClass = (ConstantClass) cpool.getConstant(hostClassIndex, Constants.CONSTANT_Class);
        return constantClass.getClassname(cpool);
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("NestHost(");
        ConstantClass constantClass = (ConstantClass) cpool.getConstant(hostClassIndex, Constants.CONSTANT_Class);
        buf.append(constantClass.getClassname(cpool));
        buf.append(")");
        return buf.toString();
    }
}
