package org.aspectj.apache.bcel.classfile;

import org.aspectj.apache.bcel.Constants;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Synthetic extends Attribute {

    private byte[] bytes;

    public Synthetic(Synthetic c) {
        this(c.getNameIndex(), c.getLength(), c.getBytes(), c.getConstantPool());
    }

    public Synthetic(int name_index, int length, byte[] bytes, ConstantPool constant_pool) {
        super(Constants.ATTR_SYNTHETIC, name_index, length, constant_pool);
        this.bytes = bytes;
    }

    Synthetic(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (byte[]) null, constant_pool);
        if (length > 0) {
            bytes = new byte[length];
            file.readFully(bytes);
            System.err.println("Synthetic attribute with length > 0");
        }
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitSynthetic(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        if (length > 0)
            file.write(bytes, 0, length);
    }

    public final byte[] getBytes() {
        return bytes;
    }

    public final void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder("Synthetic");
        if (length > 0)
            buf.append(" " + Utility.toHexString(bytes));
        return buf.toString();
    }
}
