package org.aspectj.apache.bcel.classfile.annotation;

import org.aspectj.apache.bcel.classfile.ConstantPool;

import java.io.DataOutputStream;
import java.io.IOException;

public class ArrayElementValue extends ElementValue {

    private static final ElementValue[] NO_VALUES = new ElementValue[0];

    private ElementValue[] evalues = NO_VALUES;

    public ElementValue[] getElementValuesArray() {
        return evalues;
    }

    public int getElementValuesArraySize() {
        return evalues.length;
    }

    public ArrayElementValue(ConstantPool cp) {
        super(ARRAY, cp);
    }

    public ArrayElementValue(int type, ElementValue[] datums, ConstantPool cpool) {
        super(type, cpool);
        if (type != ARRAY)
            throw new RuntimeException("Only element values of type array can be built with this ctor");
        this.evalues = datums;
    }

    public ArrayElementValue(ArrayElementValue value, ConstantPool cpool, boolean copyPoolEntries) {
        super(ARRAY, cpool);
        evalues = new ElementValue[value.getElementValuesArraySize()];
        ElementValue[] in = value.getElementValuesArray();
        for (int i = 0; i < in.length; i++) {
            evalues[i] = ElementValue.copy(in[i], cpool, copyPoolEntries);
        }
    }

    @Override
    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(type);
        dos.writeShort(evalues.length);
        for (ElementValue evalue : evalues) {
            evalue.dump(dos);
        }
    }

    @Override
    public String stringifyValue() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < evalues.length; i++) {
            ElementValue element = evalues[i];
            sb.append(element.stringifyValue());
            if ((i + 1) < evalues.length)
                sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public void addElement(ElementValue gen) {
        ElementValue[] old = evalues;
        evalues = new ElementValue[evalues.length + 1];
        System.arraycopy(old, 0, evalues, 0, old.length);
        evalues[old.length] = gen;
    }
}
