package org.aspectj.apache.bcel.classfile.annotation;

import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.generic.ObjectType;

import java.io.DataOutputStream;
import java.io.IOException;

public class ClassElementValue extends ElementValue {

    private int idx;

    protected ClassElementValue(int typeIdx, ConstantPool cpool) {
        super(ElementValue.CLASS, cpool);
        this.idx = typeIdx;
    }

    public ClassElementValue(ObjectType t, ConstantPool cpool) {
        super(ElementValue.CLASS, cpool);
        idx = cpool.addUtf8(t.getSignature());
    }

    public ClassElementValue(ClassElementValue value, ConstantPool cpool, boolean copyPoolEntries) {
        super(CLASS, cpool);
        if (copyPoolEntries) {
            idx = cpool.addUtf8(value.getClassString());
        } else {
            idx = value.getIndex();
        }
    }

    public int getIndex() {
        return idx;
    }

    public String getClassString() {
        ConstantUtf8 cu8 = (ConstantUtf8) getConstantPool().getConstant(idx);
        return cu8.getValue();
    }

    @Override
    public String stringifyValue() {
        return getClassString();
    }

    @Override
    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(type);
        dos.writeShort(idx);
    }
}
