package org.aspectj.apache.bcel.classfile.annotation;

import org.aspectj.apache.bcel.classfile.ConstantPool;

import java.io.DataOutputStream;
import java.io.IOException;

public class NameValuePair {

    private int nameIdx;

    private ElementValue value;

    private ConstantPool cpool;

    public NameValuePair(NameValuePair pair, ConstantPool cpool, boolean copyPoolEntries) {
        this.cpool = cpool;
        if (copyPoolEntries) {
            nameIdx = cpool.addUtf8(pair.getNameString());
        } else {
            nameIdx = pair.getNameIndex();
        }
        value = ElementValue.copy(pair.getValue(), cpool, copyPoolEntries);
    }

    protected NameValuePair(int idx, ElementValue value, ConstantPool cpool) {
        this.nameIdx = idx;
        this.value = value;
        this.cpool = cpool;
    }

    public NameValuePair(String name, ElementValue value, ConstantPool cpool) {
        this.nameIdx = cpool.addUtf8(name);
        this.value = value;
        this.cpool = cpool;
    }

    protected void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(nameIdx);
        value.dump(dos);
    }

    public int getNameIndex() {
        return nameIdx;
    }

    public final String getNameString() {
        return cpool.getConstantUtf8(nameIdx).getValue();
    }

    public final ElementValue getValue() {
        return value;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getNameString()).append("=").append(value.stringifyValue());
        return sb.toString();
    }
}
