package org.aspectj.apache.bcel.generic;

public final class BranchHandle extends InstructionHandle {

    private InstructionBranch bi;

    private BranchHandle(InstructionBranch i) {
        super(i);
        bi = i;
    }

    static final BranchHandle getBranchHandle(InstructionBranch i) {
        return new BranchHandle(i);
    }

    public int getPosition() {
        return bi.positionOfThisInstruction;
    }

    void setPosition(int pos) {
        this.pos = bi.positionOfThisInstruction = pos;
    }

    protected int updatePosition(int offset, int max_offset) {
        int x = bi.updatePosition(offset, max_offset);
        pos = bi.positionOfThisInstruction;
        return x;
    }

    public void setTarget(InstructionHandle ih) {
        bi.setTarget(ih);
    }

    public void updateTarget(InstructionHandle old_ih, InstructionHandle new_ih) {
        bi.updateTarget(old_ih, new_ih);
    }

    public InstructionHandle getTarget() {
        return bi.getTarget();
    }

    public void setInstruction(Instruction i) {
        super.setInstruction(i);
        bi = (InstructionBranch) i;
    }
}
