package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.Modifiers;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeAnnos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class FieldGenOrMethodGen extends Modifiers {

    protected String name;

    protected Type type;

    protected ConstantPool cp;

    private List<Attribute> attributeList = new ArrayList<>();

    protected List<AnnotationGen> annotationList = new ArrayList<>();

    protected FieldGenOrMethodGen() {
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ConstantPool getConstantPool() {
        return cp;
    }

    public void setConstantPool(ConstantPool cp) {
        this.cp = cp;
    }

    public void addAttribute(Attribute a) {
        attributeList.add(a);
    }

    public void removeAttribute(Attribute a) {
        attributeList.remove(a);
    }

    public void removeAttributes() {
        attributeList.clear();
    }

    public List<AnnotationGen> getAnnotations() {
        return annotationList;
    }

    public void addAnnotation(AnnotationGen ag) {
        annotationList.add(ag);
    }

    public void removeAnnotation(AnnotationGen ag) {
        annotationList.remove(ag);
    }

    public void removeAnnotations() {
        annotationList.clear();
    }

    public List<Attribute> getAttributes() {
        return attributeList;
    }

    public Attribute[] getAttributesImmutable() {
        Attribute[] attributes = new Attribute[attributeList.size()];
        attributeList.toArray(attributes);
        return attributes;
    }

    protected void addAnnotationsAsAttribute(ConstantPool cp) {
        Collection<RuntimeAnnos> attrs = Utility.getAnnotationAttributes(cp, annotationList);
        if (attrs != null) {
            for (Attribute attr : attrs) {
                addAttribute(attr);
            }
        }
    }

    public abstract String getSignature();
}
