package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.classfile.ConstantPool;

public class FieldInstruction extends FieldOrMethod {

    public FieldInstruction(short opcode, int index) {
        super(opcode, index);
    }

    public String toString(ConstantPool cp) {
        return org.aspectj.apache.bcel.Constants.OPCODE_NAMES[opcode] + " " + cp.constantToString(index, org.aspectj.apache.bcel.Constants.CONSTANT_Fieldref);
    }

    protected int getFieldSize(ConstantPool cpg) {
        return Type.getTypeSize(getSignature(cpg));
    }

    public Type getType(ConstantPool cpg) {
        return getFieldType(cpg);
    }

    public Type getFieldType(ConstantPool cpg) {
        return Type.getType(getSignature(cpg));
    }

    public String getFieldName(ConstantPool cpg) {
        return getName(cpg);
    }

    public int produceStack(ConstantPool cpg) {
        if (!isStackProducer()) {
            return 0;
        }
        return getFieldSize(cpg);
    }

    public int consumeStack(ConstantPool cpg) {
        if (!isStackConsumer()) {
            return 0;
        }
        if (opcode == GETFIELD) {
            return 1;
        }
        return getFieldSize(cpg) + (opcode == PUTFIELD ? 1 : 0);
    }
}
