package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantCP;
import org.aspectj.apache.bcel.classfile.ConstantNameAndType;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;

public abstract class FieldOrMethod extends InstructionCP {

    protected String signature;

    protected String name;

    private String classname;

    protected FieldOrMethod(short opcode, int index) {
        super(opcode, index);
    }

    public String getSignature(ConstantPool cp) {
        if (signature == null) {
            Constant c = cp.getConstant(index);
            ConstantCP cmr = (ConstantCP) c;
            ConstantNameAndType cnat = (ConstantNameAndType) cp.getConstant(cmr.getNameAndTypeIndex());
            signature = ((ConstantUtf8) cp.getConstant(cnat.getSignatureIndex())).getValue();
        }
        return signature;
    }

    public String getName(ConstantPool cp) {
        if (name == null) {
            ConstantCP cmr = (ConstantCP) cp.getConstant(index);
            ConstantNameAndType cnat = (ConstantNameAndType) cp.getConstant(cmr.getNameAndTypeIndex());
            name = ((ConstantUtf8) cp.getConstant(cnat.getNameIndex())).getValue();
        }
        return name;
    }

    public String getClassName(ConstantPool cp) {
        if (classname == null) {
            ConstantCP cmr = (ConstantCP) cp.getConstant(index);
            String str = cp.getConstantString(cmr.getClassIndex(), CONSTANT_Class);
            if (str.charAt(0) == '[') {
                classname = str;
            } else {
                classname = str.replace('/', '.');
            }
        }
        return classname;
    }

    public ObjectType getClassType(ConstantPool cpg) {
        return new ObjectType(getClassName(cpg));
    }

    @Override
    public ObjectType getLoadClassType(ConstantPool cpg) {
        return getClassType(cpg);
    }
}
