package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.Constants;

import java.io.DataOutputStream;
import java.io.IOException;

public class IINC extends InstructionLV {

    private int c;

    public IINC(int n, int c, boolean w) {
        super(Constants.IINC, n);
        this.c = c;
    }

    private boolean wide() {
        return ((lvar > org.aspectj.apache.bcel.Constants.MAX_BYTE) || (Math.abs(c) > Byte.MAX_VALUE));
    }

    public void dump(DataOutputStream out) throws IOException {
        if (wide()) {
            out.writeByte(WIDE);
            out.writeByte(opcode);
            out.writeShort(lvar);
            out.writeShort(c);
        } else {
            out.writeByte(opcode);
            out.writeByte(lvar);
            out.writeByte(c);
        }
    }

    public int getLength() {
        if (wide()) {
            return 6;
        } else {
            return 3;
        }
    }

    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + c;
    }

    public final int getIncrement() {
        return c;
    }

    public boolean equals(Object other) {
        if (!(other instanceof IINC)) {
            return false;
        }
        IINC o = (IINC) other;
        return o.lvar == lvar && o.c == c;
    }

    public int hashCode() {
        return opcode * 37 + lvar * (c + 17);
    }
}
