package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.ConstantPool;

import java.io.DataOutputStream;
import java.io.IOException;

public final class INVOKEINTERFACE extends InvokeInstruction {

    private int nargs;

    public INVOKEINTERFACE(int index, int nargs, int zerobyte) {
        super(Constants.INVOKEINTERFACE, index);
        if (nargs < 1) {
            throw new ClassGenException("Number of arguments must be > 0 " + nargs);
        }
        this.nargs = nargs;
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(opcode);
        out.writeShort(index);
        out.writeByte(nargs);
        out.writeByte(0);
    }

    public int getCount() {
        return nargs;
    }

    public String toString(ConstantPool cp) {
        return super.toString(cp) + " " + nargs;
    }

    public int consumeStack(ConstantPool cpg) {
        return nargs;
    }

    public boolean equals(Object other) {
        if (!(other instanceof INVOKEINTERFACE)) {
            return false;
        }
        INVOKEINTERFACE o = (INVOKEINTERFACE) other;
        return o.opcode == opcode && o.index == index && o.nargs == nargs;
    }

    public int hashCode() {
        return opcode * 37 + index * (nargs + 17);
    }
}
