package org.aspectj.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;

public class InstructionByte extends Instruction {

    private final byte theByte;

    public InstructionByte(short opcode, byte b) {
        super(opcode);
        this.theByte = b;
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(opcode);
        out.writeByte(theByte);
    }

    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + theByte;
    }

    public final byte getTypecode() {
        return theByte;
    }

    public final Type getType() {
        return new ArrayType(BasicType.getType(theByte), 1);
    }

    public boolean equals(Object other) {
        if (!(other instanceof InstructionByte)) {
            return false;
        }
        InstructionByte o = (InstructionByte) other;
        return o.opcode == opcode && o.theByte == theByte;
    }

    public int hashCode() {
        return opcode * 37 + theByte;
    }
}
