package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.classfile.Utility;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class InstructionHandle implements java.io.Serializable {

    InstructionHandle next, prev;

    Instruction instruction;

    protected int pos = -1;

    private Set<InstructionTargeter> targeters = Collections.emptySet();

    protected InstructionHandle(Instruction i) {
        setInstruction(i);
    }

    static final InstructionHandle getInstructionHandle(Instruction i) {
        return new InstructionHandle(i);
    }

    public final InstructionHandle getNext() {
        return next;
    }

    public final InstructionHandle getPrev() {
        return prev;
    }

    public final Instruction getInstruction() {
        return instruction;
    }

    public void setInstruction(Instruction i) {
        if (instruction != null) {
            instruction.dispose();
        }
        instruction = i;
    }

    public int getPosition() {
        return pos;
    }

    void setPosition(int pos) {
        this.pos = pos;
    }

    void dispose() {
        next = prev = null;
        instruction.dispose();
        instruction = null;
        pos = -1;
        removeAllTargeters();
    }

    public void removeAllTargeters() {
        targeters.clear();
    }

    public void removeTargeter(InstructionTargeter t) {
        targeters.remove(t);
    }

    public void addTargeter(InstructionTargeter t) {
        if (targeters == Collections.EMPTY_SET) {
            targeters = new HashSet<>();
        }
        targeters.add(t);
    }

    public boolean hasTargeters() {
        return !targeters.isEmpty();
    }

    public Set<InstructionTargeter> getTargeters() {
        return targeters;
    }

    public Set<InstructionTargeter> getTargetersCopy() {
        Set<InstructionTargeter> copy = new HashSet<>(targeters);
        return copy;
    }

    public String toString(boolean verbose) {
        return Utility.format(pos, 4, false, ' ') + ": " + instruction.toString(verbose);
    }

    public String toString() {
        return toString(true);
    }
}
