package org.aspectj.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;

public class InstructionShort extends Instruction {

    private final short value;

    public InstructionShort(short opcode, short value) {
        super(opcode);
        this.value = value;
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(opcode);
        out.writeShort(value);
    }

    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + value;
    }

    public boolean equals(Object other) {
        if (!(other instanceof InstructionShort)) {
            return false;
        }
        InstructionShort o = (InstructionShort) other;
        return o.opcode == opcode && o.value == value;
    }

    public int hashCode() {
        return opcode * 37 + value;
    }
}
