package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantPool;

import java.util.StringTokenizer;

public class InvokeInstruction extends FieldOrMethod {

    public InvokeInstruction(short opcode, int index) {
        super(opcode, index);
    }

    public String toString(ConstantPool cp) {
        Constant c = cp.getConstant(index);
        StringTokenizer tok = new StringTokenizer(cp.constantToString(c));
        return Constants.OPCODE_NAMES[opcode] + " " + tok.nextToken().replace('.', '/') + tok.nextToken();
    }

    public int consumeStack(ConstantPool cpg) {
        String signature = getSignature(cpg);
        int sum = Type.getArgumentSizes(signature);
        if (opcode != Constants.INVOKESTATIC) {
            sum += 1;
        }
        return sum;
    }

    public int produceStack(ConstantPool cpg) {
        return getReturnType(cpg).getSize();
    }

    public Type getType(ConstantPool cpg) {
        return getReturnType(cpg);
    }

    public String getMethodName(ConstantPool cpg) {
        return getName(cpg);
    }

    public Type getReturnType(ConstantPool cpg) {
        return Type.getReturnType(getSignature(cpg));
    }

    public Type[] getArgumentTypes(ConstantPool cpg) {
        return Type.getArgumentTypes(getSignature(cpg));
    }
}
