package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.util.ByteSequence;

import java.io.DataOutputStream;
import java.io.IOException;

public class LOOKUPSWITCH extends InstructionSelect {

    public LOOKUPSWITCH(int[] match, InstructionHandle[] targets, InstructionHandle target) {
        super(LOOKUPSWITCH, match, targets, target);
        length = (short) (9 + matchLength * 8);
        fixedLength = length;
    }

    public void dump(DataOutputStream out) throws IOException {
        super.dump(out);
        out.writeInt(matchLength);
        for (int i = 0; i < matchLength; i++) {
            out.writeInt(match[i]);
            out.writeInt(indices[i] = getTargetOffset(targets[i]));
        }
    }

    public LOOKUPSWITCH(ByteSequence bytes) throws IOException {
        super(Constants.LOOKUPSWITCH, bytes);
        matchLength = bytes.readInt();
        fixedLength = (short) (9 + matchLength * 8);
        length = (short) (fixedLength + padding);
        match = new int[matchLength];
        indices = new int[matchLength];
        targets = new InstructionHandle[matchLength];
        for (int i = 0; i < matchLength; i++) {
            match[i] = bytes.readInt();
            indices[i] = bytes.readInt();
        }
    }
}
