package org.aspectj.apache.bcel.generic;

public class LineNumberTag extends Tag {

    private final int lineNumber;

    public LineNumberTag(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return lineNumber;
    }

    public String toString() {
        return "line " + lineNumber;
    }

    public boolean equals(Object other) {
        if (!(other instanceof LineNumberTag))
            return false;
        return lineNumber == ((LineNumberTag) other).lineNumber;
    }

    public int hashCode() {
        return lineNumber;
    }
}
