package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.ExceptionConstants;
import org.aspectj.apache.bcel.classfile.ConstantPool;

import java.io.DataOutputStream;
import java.io.IOException;

public class MULTIANEWARRAY extends InstructionCP {

    private short dimensions;

    public MULTIANEWARRAY(int index, short dimensions) {
        super(Constants.MULTIANEWARRAY, index);
        this.dimensions = dimensions;
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(opcode);
        out.writeShort(index);
        out.writeByte(dimensions);
    }

    public final short getDimensions() {
        return dimensions;
    }

    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + index + " " + dimensions;
    }

    public String toString(ConstantPool cp) {
        return super.toString(cp) + " " + dimensions;
    }

    public int consumeStack(ConstantPool cpg) {
        return dimensions;
    }

    public Class[] getExceptions() {
        Class[] cs = new Class[2 + ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length];
        System.arraycopy(ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION, 0, cs, 0, ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length);
        cs[ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length + 1] = ExceptionConstants.NEGATIVE_ARRAY_SIZE_EXCEPTION;
        cs[ExceptionConstants.EXCS_CLASS_AND_INTERFACE_RESOLUTION.length] = ExceptionConstants.ILLEGAL_ACCESS_ERROR;
        return cs;
    }

    public ObjectType getLoadClassType(ConstantPool cpg) {
        Type t = getType(cpg);
        if (t instanceof ArrayType) {
            t = ((ArrayType) t).getBasicType();
        }
        return (t instanceof ObjectType) ? (ObjectType) t : null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof MULTIANEWARRAY)) {
            return false;
        }
        MULTIANEWARRAY o = (MULTIANEWARRAY) other;
        return o.opcode == opcode && o.index == index && o.dimensions == dimensions;
    }

    public int hashCode() {
        return opcode * 37 + index * (dimensions + 17);
    }
}
