package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.Repository;
import org.aspectj.apache.bcel.classfile.JavaClass;

public class ObjectType extends ReferenceType {

    private String classname;

    public ObjectType(String class_name) {
        super(Constants.T_REFERENCE, toSignature(class_name));
        this.classname = class_name;
    }

    public ObjectType(String classname, String signature) {
        super(Constants.T_REFERENCE, signature);
        this.classname = classname;
    }

    private static String toSignature(String classname) {
        StringBuilder sig = new StringBuilder();
        sig.append("L").append(classname.replace('.', '/'));
        sig.append(";");
        return sig.toString();
    }

    public String getClassName() {
        return classname;
    }

    @Override
    public int hashCode() {
        return classname.hashCode();
    }

    @Override
    public boolean equals(Object type) {
        return (type instanceof ObjectType) ? ((ObjectType) type).classname.equals(classname) : false;
    }

    public boolean referencesClass() {
        JavaClass jc = Repository.lookupClass(classname);
        if (jc == null) {
            return false;
        } else {
            return jc.isClass();
        }
    }

    public boolean referencesInterface() {
        JavaClass jc = Repository.lookupClass(classname);
        if (jc == null) {
            return false;
        } else {
            return !jc.isClass();
        }
    }

    public boolean subclassOf(ObjectType superclass) {
        if (this.referencesInterface() || superclass.referencesInterface()) {
            return false;
        }
        return Repository.instanceOf(this.classname, superclass.classname);
    }

    public boolean accessibleTo(ObjectType accessor) {
        JavaClass jc = Repository.lookupClass(classname);
        if (jc.isPublic()) {
            return true;
        } else {
            JavaClass acc = Repository.lookupClass(accessor.classname);
            return acc.getPackageName().equals(jc.getPackageName());
        }
    }
}
