package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.ConstantPool;

import java.io.DataOutputStream;
import java.io.IOException;

public class RET extends Instruction {

    private boolean wide;

    private int index;

    public RET(int index, boolean wide) {
        super(Constants.RET);
        this.index = index;
        this.wide = wide;
    }

    public void dump(DataOutputStream out) throws IOException {
        if (wide) {
            out.writeByte(Constants.WIDE);
        }
        out.writeByte(opcode);
        if (wide) {
            out.writeShort(index);
        } else {
            out.writeByte(index);
        }
    }

    public int getLength() {
        if (wide) {
            return 4;
        } else {
            return 2;
        }
    }

    public final int getIndex() {
        return index;
    }

    public final void setIndex(int index) {
        this.index = index;
        this.wide = index > Constants.MAX_BYTE;
    }

    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + index;
    }

    public Type getType(ConstantPool cp) {
        return ReturnaddressType.NO_TARGET;
    }

    public boolean equals(Object other) {
        if (!(other instanceof RET)) {
            return false;
        }
        RET o = (RET) other;
        return o.opcode == opcode && o.index == index;
    }

    public int hashCode() {
        return opcode * 37 + index;
    }
}
