package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.Constants;

public class ReturnaddressType extends Type {

    public static final ReturnaddressType NO_TARGET = new ReturnaddressType();

    private InstructionHandle returnTarget;

    private ReturnaddressType() {
        super(Constants.T_ADDRESS, "<return address>");
    }

    public ReturnaddressType(InstructionHandle returnTarget) {
        super(Constants.T_ADDRESS, "<return address targeting " + returnTarget + ">");
        this.returnTarget = returnTarget;
    }

    public boolean equals(Object rat) {
        if (!(rat instanceof ReturnaddressType))
            return false;
        return ((ReturnaddressType) rat).returnTarget.equals(this.returnTarget);
    }

    public InstructionHandle getTarget() {
        return returnTarget;
    }
}
