package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.util.ByteSequence;

import java.io.DataOutputStream;
import java.io.IOException;

public class TABLESWITCH extends InstructionSelect {

    public TABLESWITCH(int[] match, InstructionHandle[] targets, InstructionHandle target) {
        super(org.aspectj.apache.bcel.Constants.TABLESWITCH, match, targets, target);
        length = (short) (13 + matchLength * 4);
        fixedLength = length;
    }

    public void dump(DataOutputStream out) throws IOException {
        super.dump(out);
        int low = matchLength > 0 ? match[0] : 0;
        out.writeInt(low);
        int high = matchLength > 0 ? match[matchLength - 1] : 0;
        out.writeInt(high);
        for (int i = 0; i < matchLength; i++) {
            out.writeInt(indices[i] = getTargetOffset(targets[i]));
        }
    }

    public TABLESWITCH(ByteSequence bytes) throws IOException {
        super(Constants.TABLESWITCH, bytes);
        int low = bytes.readInt();
        int high = bytes.readInt();
        matchLength = high - low + 1;
        fixedLength = (short) (13 + matchLength * 4);
        length = (short) (fixedLength + padding);
        match = new int[matchLength];
        indices = new int[matchLength];
        targets = new InstructionHandle[matchLength];
        for (int i = low; i <= high; i++) {
            match[i - low] = i;
        }
        for (int i = 0; i < matchLength; i++) {
            indices[i] = bytes.readInt();
        }
    }
}
