package org.aspectj.apache.bcel.util;

import org.aspectj.apache.bcel.classfile.JavaClass;

import java.lang.ref.WeakReference;

public class ThreadLocalAwareRepository implements Repository {

    private static ThreadLocal<WeakReference<Repository>> threadLocal = new ThreadLocal<>();

    public static void setCurrentRepository(Repository repository) {
        threadLocal.set(new WeakReference<>(repository));
    }

    private static Repository currentRepository() {
        WeakReference<Repository> ref = threadLocal.get();
        Repository repo = null;
        if (ref != null) {
            repo = ref.get();
        }
        if (repo == null) {
            repo = SyntheticRepository.getInstance();
        }
        return repo;
    }

    @Override
    public void storeClass(JavaClass clazz) {
        currentRepository().storeClass(clazz);
    }

    @Override
    public void removeClass(JavaClass clazz) {
        currentRepository().removeClass(clazz);
    }

    @Override
    public JavaClass findClass(String className) {
        return currentRepository().findClass(className);
    }

    @Override
    public JavaClass loadClass(String className) throws ClassNotFoundException {
        return currentRepository().loadClass(className);
    }

    @Override
    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        return currentRepository().loadClass(clazz);
    }

    @Override
    public void clear() {
        currentRepository().clear();
    }
}
