package org.aspectj.asm;

import org.aspectj.bridge.ISourceLocation;

import java.io.File;

public interface IElementHandleProvider {

    String createHandleIdentifier(ISourceLocation location);

    String createHandleIdentifier(File sourceFile, int line, int column, int offset);

    String createHandleIdentifier(IProgramElement ipe);

    String getFileForHandle(String handle);

    int getLineNumberForHandle(String handle);

    int getOffSetForHandle(String handle);

    void initialize();
}
