package org.aspectj.asm;

import org.aspectj.asm.internal.ProgramElement;
import org.aspectj.bridge.ISourceLocation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public interface IHierarchy extends Serializable {

    IProgramElement NO_STRUCTURE = new ProgramElement(null, "<build to view structure>", IProgramElement.Kind.ERROR, null);

    IProgramElement getElement(String handle);

    IProgramElement getRoot();

    void setRoot(IProgramElement root);

    void addToFileMap(String canonicalFilePath, IProgramElement compilationUnitProgramElement);

    boolean removeFromFileMap(String canonicalFilePath);

    void setFileMap(Map<String, IProgramElement> fileMap);

    default void setFileMap(HashMap<String, IProgramElement> fileMap) {
        setFileMap((Map<String, IProgramElement>) fileMap);
    }

    Object findInFileMap(Object key);

    Set<Map.Entry<String, IProgramElement>> getFileMapEntrySet();

    boolean isValid();

    IProgramElement findElementForHandle(String handle);

    IProgramElement findElementForHandleOrCreate(String handle, boolean create);

    IProgramElement findElementForSignature(IProgramElement parent, IProgramElement.Kind kind, String signature);

    IProgramElement findElementForLabel(IProgramElement parent, IProgramElement.Kind kind, String label);

    IProgramElement findElementForType(String packageName, String typeName);

    IProgramElement findElementForSourceFile(String sourceFile);

    IProgramElement findElementForSourceLine(ISourceLocation location);

    IProgramElement findElementForSourceLine(String sourceFilePath, int lineNumber);

    IProgramElement findElementForOffSet(String sourceFilePath, int lineNumber, int offSet);

    String getConfigFile();

    void setConfigFile(String configFile);

    void flushTypeMap();

    void flushHandleMap();

    void updateHandleMap(Set<String> deletedFiles);

    IProgramElement findCloserMatchForLineNumber(IProgramElement node, int lineno);

    IProgramElement findNodeForSourceFile(IProgramElement node, String sourcefilePath);
}
