package org.aspectj.asm;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

public interface IRelationshipMap extends Serializable {

    List<IRelationship> get(IProgramElement sourceProgramElement);

    List<IRelationship> get(String sourceHandle);

    IRelationship get(IProgramElement source, IRelationship.Kind kind, String relationshipName, boolean runtimeTest, boolean createIfMissing);

    IRelationship get(IProgramElement source, IRelationship.Kind kind, String relationshipName);

    IRelationship get(String source, IRelationship.Kind kind, String relationshipName, boolean runtimeTest, boolean createIfMissing);

    void put(IProgramElement source, IRelationship relationship);

    void put(String handle, IRelationship relationship);

    boolean remove(String handle, IRelationship relationship);

    void removeAll(String source);

    void clear();

    Set<String> getEntries();
}
