package org.aspectj.asm.internal;

import org.aspectj.asm.IRelationship;

import java.util.List;

public class Relationship implements IRelationship {

    private static final long serialVersionUID = 3855166397957609120L;

    private String name;

    private Kind kind;

    private boolean isAffects;

    private String sourceHandle;

    private List<String> targets;

    private boolean hasRuntimeTest;

    public Relationship(String name, Kind kind, String sourceHandle, List<String> targets, boolean runtimeTest) {
        this.name = name;
        this.isAffects = name.equals("advises") || name.equals("declares on") || name.equals("softens") || name.equals("matched by") || name.equals("declared on") || name.equals("annotates");
        this.kind = kind;
        this.sourceHandle = sourceHandle;
        this.targets = targets;
        this.hasRuntimeTest = runtimeTest;
    }

    public String getName() {
        return name;
    }

    public Kind getKind() {
        return kind;
    }

    public String toString() {
        return name;
    }

    public String getSourceHandle() {
        return sourceHandle;
    }

    public List<String> getTargets() {
        return targets;
    }

    public void addTarget(String handle) {
        if (targets.contains(handle)) {
            return;
        }
        targets.add(handle);
    }

    public boolean hasRuntimeTest() {
        return hasRuntimeTest;
    }

    public boolean isAffects() {
        return isAffects;
    }
}
