package org.aspectj.bridge;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;

public class // XXX move porters out, handle proxy better
AbortException extends RuntimeException {

    private static final long serialVersionUID = -7211791639898586417L;

    private boolean isSilent = false;

    public static final String NO_MESSAGE_TEXT = "AbortException (no message)";

    private static final ArrayList<AbortException> porters = new ArrayList<>();

    public static AbortException borrowPorter(IMessage message) {
        AbortException result;
        synchronized (porters) {
            if (porters.size() > 0) {
                result = porters.get(0);
            } else {
                result = new AbortException();
                result.setIsSilent(false);
            }
        }
        result.setIMessage(message);
        result.isPorter = true;
        return result;
    }

    public static void returnPorter(AbortException porter) {
        synchronized (porters) {
            if (porters.contains(porter)) {
                throw new IllegalStateException("already have " + porter);
            } else {
                porters.add(porter);
            }
        }
    }

    private static String extractMessage(IMessage message) {
        if (null == message) {
            return NO_MESSAGE_TEXT;
        } else {
            String m = message.getMessage();
            if (null == m) {
                return NO_MESSAGE_TEXT;
            } else {
                return m;
            }
        }
    }

    protected IMessage message;

    protected boolean isPorter;

    public AbortException() {
        this("ABORT");
        isSilent = true;
    }

    public AbortException(String s) {
        super(null != s ? s : NO_MESSAGE_TEXT);
        this.message = null;
    }

    public AbortException(IMessage message) {
        super(extractMessage(message));
        this.message = message;
    }

    public IMessage getIMessage() {
        return message;
    }

    public boolean isPorter() {
        return isPorter;
    }

    public Throwable getThrown() {
        Throwable result = null;
        IMessage m = getIMessage();
        if (null != m) {
            result = m.getThrown();
            if (result instanceof AbortException) {
                return ((AbortException) result).getThrown();
            }
        }
        return result;
    }

    private void setIMessage(IMessage message) {
        this.message = message;
    }

    public String getMessage() {
        String message = super.getMessage();
        if ((null == message) || (NO_MESSAGE_TEXT == message)) {
            IMessage m = getIMessage();
            if (null != m) {
                message = m.getMessage();
                if (null == message) {
                    Throwable thrown = m.getThrown();
                    if (null != thrown) {
                        message = thrown.getMessage();
                    }
                }
            }
            if (null == message) {
                message = NO_MESSAGE_TEXT;
            }
        }
        return message;
    }

    public void printStackTrace() {
        printStackTrace(System.out);
    }

    public void printStackTrace(PrintStream s) {
        IMessage m = getIMessage();
        Throwable thrown = (null == m ? null : m.getThrown());
        if (!isPorter() || (null == thrown)) {
            s.println("Message: " + m);
            super.printStackTrace(s);
        } else {
            thrown.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        IMessage m = getIMessage();
        Throwable thrown = (null == m ? null : m.getThrown());
        if (null == thrown) {
            if (isPorter()) {
                s.println("(Warning porter AbortException without thrown)");
            }
            s.println("Message: " + m);
            super.printStackTrace(s);
        } else {
            thrown.printStackTrace(s);
        }
    }

    public boolean isSilent() {
        return isSilent;
    }

    public void setIsSilent(boolean isSilent) {
        this.isSilent = isSilent;
    }
}
