package org.aspectj.bridge;

import java.io.File;

public interface ISourceLocation extends java.io.Serializable {

    int MAX_LINE = Integer.MAX_VALUE / 2;

    int MAX_COLUMN = MAX_LINE;

    File NO_FILE = new File("ISourceLocation.NO_FILE");

    int NO_COLUMN = Integer.MIN_VALUE + 1;

    ISourceLocation EMPTY = new SourceLocation(NO_FILE, 0, 0, 0);

    File getSourceFile();

    int getLine();

    int getColumn();

    int getOffset();

    int getEndLine();

    String getContext();

    String getSourceFileName();
}
