package org.aspectj.internal.lang.reflect;

import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.lang.reflect.InterTypeConstructorDeclaration;

import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class InterTypeConstructorDeclarationImpl extends InterTypeDeclarationImpl implements InterTypeConstructorDeclaration {

    private Method baseMethod;

    public InterTypeConstructorDeclarationImpl(AjType<?> decType, String target, int mods, Method baseMethod) {
        super(decType, target, mods);
        this.baseMethod = baseMethod;
    }

    public AjType<?>[] getParameterTypes() {
        Class<?>[] baseTypes = baseMethod.getParameterTypes();
        AjType<?>[] ret = new AjType<?>[baseTypes.length - 1];
        for (int i = 1; i < baseTypes.length; i++) {
            ret[i - 1] = AjTypeSystem.getAjType(baseTypes[i]);
        }
        return ret;
    }

    public Type[] getGenericParameterTypes() {
        Type[] baseTypes = baseMethod.getGenericParameterTypes();
        Type[] ret = new AjType<?>[baseTypes.length - 1];
        for (int i = 1; i < baseTypes.length; i++) {
            if (baseTypes[i] instanceof Class) {
                ret[i - 1] = AjTypeSystem.getAjType((Class<?>) baseTypes[i]);
            } else {
                ret[i - 1] = baseTypes[i];
            }
        }
        return ret;
    }

    public AjType<?>[] getExceptionTypes() {
        Class<?>[] baseTypes = baseMethod.getExceptionTypes();
        AjType<?>[] ret = new AjType<?>[baseTypes.length];
        for (int i = 0; i < baseTypes.length; i++) {
            ret[i] = AjTypeSystem.getAjType(baseTypes[i]);
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(java.lang.reflect.Modifier.toString(getModifiers()));
        sb.append(" ");
        sb.append(this.targetTypeName);
        sb.append(".new");
        sb.append("(");
        AjType<?>[] pTypes = getParameterTypes();
        for (int i = 0; i < (pTypes.length - 1); i++) {
            sb.append(pTypes[i].toString());
            sb.append(", ");
        }
        if (pTypes.length > 0) {
            sb.append(pTypes[pTypes.length - 1].toString());
        }
        sb.append(")");
        return sb.toString();
    }
}
