package org.aspectj.lang.reflect;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public interface AjType<T> extends Type, AnnotatedElement {

    String getName();

    Package getPackage();

    AjType<?>[] getInterfaces();

    int getModifiers();

    Class<T> getJavaClass();

    AjType<?> getSupertype();

    Type getGenericSupertype();

    Method getEnclosingMethod();

    Constructor getEnclosingConstructor();

    AjType<?> getEnclosingType();

    AjType<?> getDeclaringType();

    PerClause getPerClause();

    AjType<?>[] getAjTypes();

    AjType<?>[] getDeclaredAjTypes();

    Constructor getConstructor(AjType<?>... parameterTypes) throws NoSuchMethodException;

    Constructor[] getConstructors();

    Constructor getDeclaredConstructor(AjType<?>... parameterTypes) throws NoSuchMethodException;

    Constructor[] getDeclaredConstructors();

    Field getDeclaredField(String name) throws NoSuchFieldException;

    Field[] getDeclaredFields();

    Field getField(String name) throws NoSuchFieldException;

    Field[] getFields();

    Method getDeclaredMethod(String name, AjType<?>... parameterTypes) throws NoSuchMethodException;

    Method getMethod(String name, AjType<?>... parameterTypes) throws NoSuchMethodException;

    Method[] getDeclaredMethods();

    Method[] getMethods();

    Pointcut getDeclaredPointcut(String name) throws NoSuchPointcutException;

    Pointcut getPointcut(String name) throws NoSuchPointcutException;

    Pointcut[] getDeclaredPointcuts();

    Pointcut[] getPointcuts();

    Advice[] getDeclaredAdvice(AdviceKind... ofTypes);

    Advice[] getAdvice(AdviceKind... ofTypes);

    Advice getAdvice(String name) throws NoSuchAdviceException;

    Advice getDeclaredAdvice(String name) throws NoSuchAdviceException;

    InterTypeMethodDeclaration getDeclaredITDMethod(String name, AjType<?> target, AjType<?>... parameterTypes) throws NoSuchMethodException;

    InterTypeMethodDeclaration[] getDeclaredITDMethods();

    InterTypeMethodDeclaration getITDMethod(String name, AjType<?> target, AjType<?>... parameterTypes) throws NoSuchMethodException;

    InterTypeMethodDeclaration[] getITDMethods();

    InterTypeConstructorDeclaration getDeclaredITDConstructor(AjType<?> target, AjType<?>... parameterTypes) throws NoSuchMethodException;

    InterTypeConstructorDeclaration[] getDeclaredITDConstructors();

    InterTypeConstructorDeclaration getITDConstructor(AjType<?> target, AjType<?>... parameterTypes) throws NoSuchMethodException;

    InterTypeConstructorDeclaration[] getITDConstructors();

    InterTypeFieldDeclaration getDeclaredITDField(String name, AjType<?> target) throws NoSuchFieldException;

    InterTypeFieldDeclaration[] getDeclaredITDFields();

    InterTypeFieldDeclaration getITDField(String name, AjType<?> target) throws NoSuchFieldException;

    InterTypeFieldDeclaration[] getITDFields();

    DeclareErrorOrWarning[] getDeclareErrorOrWarnings();

    DeclareParents[] getDeclareParents();

    DeclareSoft[] getDeclareSofts();

    DeclareAnnotation[] getDeclareAnnotations();

    DeclarePrecedence[] getDeclarePrecedence();

    T[] getEnumConstants();

    TypeVariable<Class<T>>[] getTypeParameters();

    boolean isEnum();

    boolean isInstance(Object o);

    boolean isInterface();

    boolean isLocalClass();

    boolean isMemberClass();

    boolean isArray();

    boolean isPrimitive();

    boolean isAspect();

    boolean isMemberAspect();

    boolean isPrivileged();
}
