package org.aspectj.runtime.reflect;

import org.aspectj.lang.reflect.ConstructorSignature;

import java.lang.reflect.Constructor;

class ConstructorSignatureImpl extends CodeSignatureImpl implements ConstructorSignature {

    private Constructor<?> constructor;

    ConstructorSignatureImpl(int modifiers, Class<?> declaringType, Class[] parameterTypes, String[] parameterNames, Class[] exceptionTypes) {
        super(modifiers, "<init>", declaringType, parameterTypes, parameterNames, exceptionTypes);
    }

    ConstructorSignatureImpl(String stringRep) {
        super(stringRep);
    }

    public String getName() {
        return "<init>";
    }

    protected String createToString(StringMaker sm) {
        StringBuffer buf = new StringBuffer();
        buf.append(sm.makeModifiersString(getModifiers()));
        buf.append(sm.makePrimaryTypeName(getDeclaringType(), getDeclaringTypeName()));
        sm.addSignature(buf, getParameterTypes());
        sm.addThrows(buf, getExceptionTypes());
        return buf.toString();
    }

    public Constructor getConstructor() {
        if (constructor == null) {
            try {
                constructor = getDeclaringType().getDeclaredConstructor(getParameterTypes());
            } catch (Exception ex) {
                ;
            }
        }
        return constructor;
    }
}
