package org.aspectj.runtime.reflect;

import org.aspectj.lang.reflect.FieldSignature;

import java.lang.reflect.Field;

public class FieldSignatureImpl extends MemberSignatureImpl implements FieldSignature {

    Class<?> fieldType;

    private Field field;

    FieldSignatureImpl(int modifiers, String name, Class<?> declaringType, Class<?> fieldType) {
        super(modifiers, name, declaringType);
        this.fieldType = fieldType;
    }

    FieldSignatureImpl(String stringRep) {
        super(stringRep);
    }

    public Class getFieldType() {
        if (fieldType == null)
            fieldType = extractType(3);
        return fieldType;
    }

    protected String createToString(StringMaker sm) {
        StringBuilder buf = new StringBuilder();
        buf.append(sm.makeModifiersString(getModifiers()));
        if (sm.includeArgs)
            buf.append(sm.makeTypeName(getFieldType()));
        if (sm.includeArgs)
            buf.append(" ");
        buf.append(sm.makePrimaryTypeName(getDeclaringType(), getDeclaringTypeName()));
        buf.append(".");
        buf.append(getName());
        return buf.toString();
    }

    public Field getField() {
        if (field == null) {
            try {
                field = getDeclaringType().getDeclaredField(getName());
            } catch (Exception ex) {
                ;
            }
        }
        return field;
    }
}
