package org.aspectj.runtime.reflect;

import org.aspectj.lang.reflect.InitializerSignature;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

class InitializerSignatureImpl extends CodeSignatureImpl implements InitializerSignature {

    private Constructor<?> constructor;

    InitializerSignatureImpl(int modifiers, Class<?> declaringType) {
        super(modifiers, Modifier.isStatic(modifiers) ? "<clinit>" : "<init>", declaringType, EMPTY_CLASS_ARRAY, EMPTY_STRING_ARRAY, EMPTY_CLASS_ARRAY);
    }

    InitializerSignatureImpl(String stringRep) {
        super(stringRep);
    }

    public String getName() {
        return Modifier.isStatic(getModifiers()) ? "<clinit>" : "<init>";
    }

    protected String createToString(StringMaker sm) {
        StringBuilder buf = new StringBuilder();
        buf.append(sm.makeModifiersString(getModifiers()));
        buf.append(sm.makePrimaryTypeName(getDeclaringType(), getDeclaringTypeName()));
        buf.append(".");
        buf.append(getName());
        return buf.toString();
    }

    public Constructor getInitializer() {
        if (constructor == null) {
            try {
                constructor = getDeclaringType().getDeclaredConstructor(getParameterTypes());
            } catch (Exception ex) {
                ;
            }
        }
        return constructor;
    }
}
