package org.aspectj.runtime.reflect;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.SourceLocation;
import org.aspectj.runtime.internal.AroundClosure;

import java.util.Stack;

class JoinPointImpl implements ProceedingJoinPoint {

    static class StaticPartImpl implements JoinPoint.StaticPart {

        String kind;

        Signature signature;

        SourceLocation sourceLocation;

        private int id;

        public StaticPartImpl(int id, String kind, Signature signature, SourceLocation sourceLocation) {
            this.kind = kind;
            this.signature = signature;
            this.sourceLocation = sourceLocation;
            this.id = id;
        }

        public int getId() {
            return id;
        }

        public String getKind() {
            return kind;
        }

        public Signature getSignature() {
            return signature;
        }

        public SourceLocation getSourceLocation() {
            return sourceLocation;
        }

        String toString(StringMaker sm) {
            StringBuilder buf = new StringBuilder();
            buf.append(sm.makeKindName(getKind()));
            buf.append("(");
            buf.append(((SignatureImpl) getSignature()).toString(sm));
            buf.append(")");
            return buf.toString();
        }

        public final String toString() {
            return toString(StringMaker.middleStringMaker);
        }

        public final String toShortString() {
            return toString(StringMaker.shortStringMaker);
        }

        public final String toLongString() {
            return toString(StringMaker.longStringMaker);
        }
    }

    static class EnclosingStaticPartImpl extends StaticPartImpl implements EnclosingStaticPart {

        public EnclosingStaticPartImpl(int count, String kind, Signature signature, SourceLocation sourceLocation) {
            super(count, kind, signature, sourceLocation);
        }
    }

    static class InheritableThreadLocalAroundClosureStack extends InheritableThreadLocal<Stack<AroundClosure>> {

        @Override
        protected Stack<AroundClosure> initialValue() {
            return new Stack<>();
        }

        @Override
        protected Stack<AroundClosure> childValue(Stack<AroundClosure> parentValue) {
            return (Stack<AroundClosure>) parentValue.clone();
        }
    }

    Object _this;

    Object target;

    Object[] args;

    org.aspectj.lang.JoinPoint.StaticPart staticPart;

    public JoinPointImpl(org.aspectj.lang.JoinPoint.StaticPart staticPart, Object _this, Object target, Object[] args) {
        this.staticPart = staticPart;
        this._this = _this;
        this.target = target;
        this.args = args;
    }

    public Object getThis() {
        return _this;
    }

    public Object getTarget() {
        return target;
    }

    public Object[] getArgs() {
        if (args == null) {
            args = new Object[0];
        }
        Object[] argsCopy = new Object[args.length];
        System.arraycopy(args, 0, argsCopy, 0, args.length);
        return argsCopy;
    }

    public org.aspectj.lang.JoinPoint.StaticPart getStaticPart() {
        return staticPart;
    }

    public String getKind() {
        return staticPart.getKind();
    }

    public Signature getSignature() {
        return staticPart.getSignature();
    }

    public SourceLocation getSourceLocation() {
        return staticPart.getSourceLocation();
    }

    public final String toString() {
        return staticPart.toString();
    }

    public final String toShortString() {
        return staticPart.toShortString();
    }

    public final String toLongString() {
        return staticPart.toLongString();
    }

    private AroundClosure arc = null;

    private InheritableThreadLocalAroundClosureStack arcs = null;

    public void set$AroundClosure(AroundClosure arc) {
        this.arc = arc;
    }

    public void stack$AroundClosure(AroundClosure arc) {
        if (arcs == null) {
            arcs = new InheritableThreadLocalAroundClosureStack();
        }
        if (arc == null) {
            this.arcs.get().pop();
        } else {
            this.arcs.get().push(arc);
        }
    }

    public Object proceed() throws Throwable {
        if (arcs == null) {
            if (arc == null) {
                return null;
            } else {
                return arc.run(arc.getState());
            }
        } else {
            final AroundClosure ac = arcs.get().peek();
            return ac.run(ac.getState());
        }
    }

    public Object proceed(Object[] adviceBindings) throws Throwable {
        AroundClosure ac = null;
        if (arcs == null) {
            ac = arc;
        } else {
            ac = arcs.get().peek();
        }
        if (ac == null) {
            return null;
        } else {
            int flags = ac.getFlags();
            boolean unset = (flags & 0x100000) != 0;
            boolean thisTargetTheSame = (flags & 0x010000) != 0;
            boolean hasThis = (flags & 0x001000) != 0;
            boolean bindsThis = (flags & 0x000100) != 0;
            boolean hasTarget = (flags & 0x000010) != 0;
            boolean bindsTarget = (flags & 0x000001) != 0;
            Object[] state = ac.getState();
            int firstArgumentIndexIntoAdviceBindings = 0;
            int firstArgumentIndexIntoState = 0;
            firstArgumentIndexIntoState += (hasThis ? 1 : 0);
            firstArgumentIndexIntoState += (hasTarget && !thisTargetTheSame ? 1 : 0);
            if (hasThis) {
                if (bindsThis) {
                    firstArgumentIndexIntoAdviceBindings = 1;
                    state[0] = adviceBindings[0];
                } else {
                }
            }
            if (hasTarget) {
                if (bindsTarget) {
                    if (thisTargetTheSame) {
                        firstArgumentIndexIntoAdviceBindings = 1 + (bindsThis ? 1 : 0);
                        state[0] = adviceBindings[(bindsThis ? 1 : 0)];
                    } else {
                        int targetPositionInAdviceBindings = (hasThis && bindsThis) ? 1 : 0;
                        firstArgumentIndexIntoAdviceBindings = ((hasThis && bindsThis) ? 1 : 0) + ((hasTarget && bindsTarget && !thisTargetTheSame) ? 1 : 0);
                        state[hasThis ? 1 : 0] = adviceBindings[targetPositionInAdviceBindings];
                    }
                } else {
                }
            }
            for (int i = firstArgumentIndexIntoAdviceBindings; i < adviceBindings.length; i++) {
                state[firstArgumentIndexIntoState + (i - firstArgumentIndexIntoAdviceBindings)] = adviceBindings[i];
            }
            return ac.run(state);
        }
    }
}
