package org.aspectj.weaver;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractAnnotationAJ implements AnnotationAJ {

    protected final ResolvedType type;

    private Set<String> supportedTargets = null;

    public AbstractAnnotationAJ(ResolvedType type) {
        this.type = type;
    }

    public final ResolvedType getType() {
        return type;
    }

    public final String getTypeSignature() {
        return type.getSignature();
    }

    public final String getTypeName() {
        return type.getName();
    }

    public final boolean allowedOnAnnotationType() {
        ensureAtTargetInitialized();
        if (supportedTargets.isEmpty()) {
            return true;
        }
        return supportedTargets.contains("ANNOTATION_TYPE");
    }

    public final boolean allowedOnField() {
        ensureAtTargetInitialized();
        if (supportedTargets.isEmpty()) {
            return true;
        }
        return supportedTargets.contains("FIELD");
    }

    public final boolean allowedOnRegularType() {
        ensureAtTargetInitialized();
        if (supportedTargets.isEmpty()) {
            return true;
        }
        return supportedTargets.contains("TYPE");
    }

    public final void ensureAtTargetInitialized() {
        if (supportedTargets == null) {
            AnnotationAJ atTargetAnnotation = retrieveAnnotationOnAnnotation(UnresolvedType.AT_TARGET);
            if (atTargetAnnotation == null) {
                supportedTargets = Collections.emptySet();
            } else {
                supportedTargets = atTargetAnnotation.getTargets();
            }
        }
    }

    public final String getValidTargets() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Iterator<String> iter = supportedTargets.iterator(); iter.hasNext(); ) {
            String evalue = iter.next();
            sb.append(evalue);
            if (iter.hasNext()) {
                sb.append(",");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public final boolean specifiesTarget() {
        ensureAtTargetInitialized();
        return !supportedTargets.isEmpty();
    }

    private final AnnotationAJ retrieveAnnotationOnAnnotation(UnresolvedType requiredAnnotationSignature) {
        AnnotationAJ[] annos = type.getAnnotations();
        for (AnnotationAJ a : annos) {
            if (a.getTypeSignature().equals(requiredAnnotationSignature.getSignature())) {
                return a;
            }
        }
        return null;
    }

    public abstract boolean isRuntimeVisible();

    public abstract Set<String> getTargets();

    public abstract boolean hasNameValuePair(String name, String value);

    public abstract boolean hasNamedValue(String name);

    public abstract String stringify();
}
