package org.aspectj.weaver;

public abstract class AnnotationValue {

    protected int valueKind;

    public static final int STRING = 's';

    public static final int ENUM_CONSTANT = 'e';

    public static final int CLASS = 'c';

    public static final int ANNOTATION = '@';

    public static final int ARRAY = '[';

    public static final int PRIMITIVE_INT = 'I';

    public static final int PRIMITIVE_BYTE = 'B';

    public static final int PRIMITIVE_CHAR = 'C';

    public static final int PRIMITIVE_DOUBLE = 'D';

    public static final int PRIMITIVE_FLOAT = 'F';

    public static final int PRIMITIVE_LONG = 'J';

    public static final int PRIMITIVE_SHORT = 'S';

    public static final int PRIMITIVE_BOOLEAN = 'Z';

    public abstract String stringify();

    public AnnotationValue(int kind) {
        valueKind = kind;
    }

    public static String whatKindIsThis(int kind) {
        switch (kind) {
            case PRIMITIVE_BYTE:
                return "byte";
            case PRIMITIVE_CHAR:
                return "char";
            case PRIMITIVE_DOUBLE:
                return "double";
            case PRIMITIVE_FLOAT:
                return "float";
            case PRIMITIVE_INT:
                return "int";
            case PRIMITIVE_LONG:
                return "long";
            case PRIMITIVE_SHORT:
                return "short";
            case PRIMITIVE_BOOLEAN:
                return "boolean";
            case 's':
                return "string";
            case 'e':
                return "enum";
            case 'c':
                return "class";
            case '@':
                return "annotation";
            case '[':
                return "array";
            default:
                throw new RuntimeException("Dont know what this is : " + kind);
        }
    }
}
